<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('leads', function (Blueprint $table) {
            $table->id();

            // Basic lead identity
            $table->enum('lead_type', ['individual', 'corporate'])->default('individual');

            // For individual leads
            $table->string('first_name')->nullable();
            $table->string('middle_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('email')->nullable()->unique();
            $table->string('phone')->nullable();

            // For corporate leads
            $table->string('company_name')->nullable();
            $table->string('contact_person')->nullable();
            $table->string('contact_phone')->nullable();
            $table->string('contact_email')->nullable();
            $table->string('industry')->nullable();

            // Common fields
            $table->text('notes')->nullable();
            $table->enum('source', ['website', 'walk-in', 'phone call', 'referral', 'agent', 'event'])->default('website');
            $table->enum('status', ['new', 'contacted', 'qualified', 'converted', 'rejected', 'lost'])->default('new');
            $table->enum('priority', ['low', 'medium', 'high'])->default('medium');

            // Follow-up and ownership
            $table->timestamp('last_contacted_at')->nullable();
            $table->timestamp('next_follow_up_at')->nullable();
            $table->foreignId('assigned_to')->nullable()->constrained('users')->nullOnDelete(); // Staff assigned

            // If converted, link to customer or corporate customer
            $table->foreignId('customer_id')->nullable()->constrained('customers')->nullOnDelete();
            $table->foreignId('corporate_customer_id')->nullable()->constrained('corporate_customers')->nullOnDelete();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('leads');
    }
};
